<?php
/* --------------------------------------------------------------
   LanguageRepository.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Repositories;

use Gambio\Core\Language\Language;
use Gambio\Core\Language\LanguageCode;
use Gambio\Core\Language\LanguageId;
use Gambio\Core\Language\Languages;
use Gambio\Core\Language\LanguageSqlCriteria;

/**
 * Class LanguageRepository
 *
 * @package Gambio\Core\Language\Repositories
 */
class LanguageRepository implements \Gambio\Core\Language\LanguageRepository
{
    /**
     * @var LanguageMapper
     */
    private $mapper;
    
    /**
     * @var LanguageReader
     */
    private $reader;
    
    
    /**
     * LanguageRepository constructor.
     *
     * @param LanguageMapper $mapper
     * @param LanguageReader $reader
     */
    public function __construct(LanguageMapper $mapper, LanguageReader $reader)
    {
        $this->mapper = $mapper;
        $this->reader = $reader;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getAll(LanguageSqlCriteria $criteria): Languages
    {
        $languagesData = $this->reader->getAll($criteria);
        
        return $this->mapper->mapLanguages($languagesData);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getById(LanguageId $id): Language
    {
        $languageData = $this->reader->getById($id);
        
        return $this->mapper->mapLanguage($languageData);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getByCode(LanguageCode $code): Language
    {
        $languageData = $this->reader->getByCode($code);
        
        return $this->mapper->mapLanguage($languageData);
    }
}